sub Main()
    mp = CreateObject("roMessagePort")

    vm = CreateObject("roVideoMode")
    w = vm.GetResX()
    h = vm.GetResY()
    r = CreateObject("roRectangle", 0, 0, w, h)

    ' Rotation in degrees from registry: 0/90/180/270 (default 0)
    reg = CreateObject("roRegistrySection", "app")
    rot = reg.Read("rotate_deg")
    if rot = invalid or Len(rot) = 0 then rot = "0"
    rot = Strip(rot)

    aa = CreateObject("roAssociativeArray")
    aa.url = "file:///index.html"

    aa.nodejs_enabled = true
    aa.brightsign_js_objects_enabled = true

    ' Persist LocalStorage/WebDatabase/AppCache across reboots
    aa.storage_path = "/local/"

    ' Enable mouse + keyboard focus for HTML
    aa.mouse_enabled = true
    aa.focus_enabled = true

    ' Apply transform based on registry
    if rot = "90" then
        aa.transform = "rot90"
    else if rot = "180" then
        aa.transform = "rot180"
    else if rot = "270" then
        aa.transform = "rot270"
    else
        aa.transform = "identity"
    end if

    html = CreateObject("roHtmlWidget", r, aa)
    html.SetPort(mp)
    html.Show()

    while true
        msg = Wait(0, mp)
    end while
end sub

function Strip(s as String) as String
    while Len(s) > 0 and (Left(s, 1) = " " or Left(s, 1) = Chr(9) or Left(s, 1) = Chr(13) or Left(s, 1) = Chr(10))
        s = Mid(s, 2)
    end while
    while Len(s) > 0 and (Right(s, 1) = " " or Right(s, 1) = Chr(9) or Right(s, 1) = Chr(13) or Right(s, 1) = Chr(10))
        s = Left(s, Len(s) - 1)
    end while
    return s
end function
